<?php
session_start();
include '../includes/db.php';

if (!isset($_SESSION['admin_logged_in'])) {
    header("Location: index.php");
    exit;
}

/* ===== Dashboard Stats ===== */
$today = date('Y-m-d');

$todayCount = $conn->query(
  "SELECT COUNT(*) c FROM appointments WHERE appointment_date='$today'"
)->fetch_assoc()['c'];

$pendingCount = $conn->query(
  "SELECT COUNT(*) c FROM appointments WHERE status='Pending'"
)->fetch_assoc()['c'];

$completedCount = $conn->query(
  "SELECT COUNT(*) c FROM appointments WHERE status='Completed'"
)->fetch_assoc()['c'];

$queryCount = $conn->query(
  "SELECT COUNT(*) c FROM contact_queries"
)->fetch_assoc()['c'];

/* ===== Filters ===== */
$where = [];
$params = [];
$types = '';

if (!empty($_GET['filter_date'])) {
  $where[] = "appointment_date = ?";
  $params[] = $_GET['filter_date'];
  $types .= 's';
}

if (!empty($_GET['filter_status'])) {
  $where[] = "status = ?";
  $params[] = $_GET['filter_status'];
  $types .= 's';
}

$sql = "SELECT * FROM appointments";
if ($where) {
  $sql .= " WHERE " . implode(" AND ", $where);
}
$sql .= " ORDER BY appointment_date DESC, appointment_time ASC";

$stmt = $conn->prepare($sql);
if ($params) {
  $stmt->bind_param($types, ...$params);
}
$stmt->execute();
$result = $stmt->get_result();

/* ===== Contact Queries ===== */
$qResult = $conn->query(
  "SELECT * FROM contact_queries ORDER BY created_at DESC"
);
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>Admin Dashboard | Doctor Panel</title>
<meta name="viewport" content="width=device-width, initial-scale=1.0">

<style>
*{margin:0;padding:0;box-sizing:border-box;font-family:Poppins,Arial}
body{background:#f4f7fb;color:#333}

/* TOP BAR */
.topbar{
  background:#fff;padding:15px 30px;
  display:flex;justify-content:space-between;align-items:center;
  box-shadow:0 5px 20px rgba(0,0,0,.08)
}
.topbar h2{color:#2a2a72}
.topbar a{
  text-decoration:none;background:#ff758c;color:#fff;
  padding:8px 16px;border-radius:10px;font-weight:500
}

/* STATS */
.stats{
  display:grid;grid-template-columns:repeat(auto-fit,minmax(220px,1fr));
  gap:25px;margin:30px
}
.card{
  background:#fff;padding:25px;border-radius:22px;
  box-shadow:0 10px 25px rgba(0,0,0,.1);text-align:center
}
.card h3{color:#5563DE}
.card p{font-size:2.2em;font-weight:600}

/* TABLE */
.table-box{
  background:#fff;margin:30px;padding:25px;border-radius:22px;
  box-shadow:0 10px 25px rgba(0,0,0,.1);overflow-x:auto
}
table{width:100%;border-collapse:collapse;min-width:1300px}
th,td{padding:14px;font-size:14px}
th{background:#5563DE;color:#fff;position:sticky;top:0}
tr:nth-child(even){background:#f8f9ff}

/* BADGES */
.badge{
  padding:6px 12px;border-radius:20px;
  font-size:12px;color:#fff;font-weight:500
}
.Pending{background:#f0ad4e}
.Paid{background:#17a2b8}
.Confirmed{background:#28a745}
.Completed{background:#0275d8}
.Cancelled{background:#d9534f}

/* ACTION BUTTONS (UPDATED COLORS) */
.actions a{
  text-decoration:none;
  padding:6px 10px;
  border-radius:8px;
  font-size:12px;
  color:#fff;
  display:inline-block;
  margin-bottom:4px
}
.btn-confirm{background:#28a745}   /* Green */
.btn-complete{background:#0275d8}  /* Blue */
.btn-cancel{background:#d9534f}    /* Red */
.btn-delete{background:#6c757d}    /* Grey */

/* PRESCRIPTION */
textarea{
  width:180px;height:80px;border-radius:8px;
  padding:6px;font-size:13px;border:1px solid #ccc
}
.save-btn{
  margin-top:5px;padding:5px 10px;border:none;
  border-radius:6px;background:#5563DE;color:#fff;
  font-size:12px;cursor:pointer
}
</style>
</head>

<body>

<div class="topbar">
  <h2>Welcome, <?= htmlspecialchars($_SESSION['admin_username']) ?></h2>
  <a href="logout.php">Logout</a>
</div>

<div class="stats">
  <div class="card"><h3>Today's Appointments</h3><p><?= $todayCount ?></p></div>
  <div class="card"><h3>Pending</h3><p><?= $pendingCount ?></p></div>
  <div class="card"><h3>Completed</h3><p><?= $completedCount ?></p></div>
  <div class="card"><h3>Contact Queries</h3><p><?= $queryCount ?></p></div>
</div>

<div class="table-box">
<h3 style="color:#2a2a72">All Appointments</h3>

<table>
<thead>
<tr>
<th>ID</th>
<th>Patient</th>
<th>Phone</th>
<th>Date</th>
<th>Time</th>
<th>Type</th>
<th>Payment</th>
<th>Proof</th>
<th>Status</th>
<th>Prescription</th>
<th>Actions</th>
</tr>
</thead>
<tbody>

<?php while($row = $result->fetch_assoc()): ?>
<tr>
<td><?= $row['id'] ?></td>
<td><?= htmlspecialchars($row['name']) ?></td>
<td><?= htmlspecialchars($row['phone']) ?></td>
<td><?= $row['appointment_date'] ?></td>
<td><?= date("h:i A", strtotime($row['appointment_time'])) ?></td>
<td><?= $row['appointment_type'] ?></td>

<td>
<span class="badge <?= $row['payment_status']=='Paid'?'Paid':'Pending' ?>">
<?= $row['payment_status'] ?>
</span>
</td>

<td>
<?php if(!empty($row['payment_screenshot'])): ?>
<a href="../uploads/payments/<?= $row['payment_screenshot'] ?>" target="_blank">View</a>
<?php else: ?>—<?php endif; ?>
</td>

<td><span class="badge <?= $row['status'] ?>"><?= $row['status'] ?></span></td>

<td>
<form method="post" action="save_prescription.php">
<input type="hidden" name="id" value="<?= $row['id'] ?>">
<textarea name="prescription"><?= htmlspecialchars($row['prescription'] ?? '') ?></textarea>
<br><button class="save-btn">Save</button>
</form>
</td>

<td class="actions">
<?php if($row['payment_status']=='Paid'): ?>
<a class="btn-confirm" href="update_status.php?id=<?= $row['id'] ?>&status=Confirmed">Confirm</a>
<?php endif; ?>
<a class="btn-complete" href="update_status.php?id=<?= $row['id'] ?>&status=Completed">Complete</a>
<a class="btn-cancel" href="update_status.php?id=<?= $row['id'] ?>&status=Cancelled">Cancel</a>
<a class="btn-delete" href="delete_appointment.php?id=<?= $row['id'] ?>" onclick="return confirm('Delete?')">Delete</a>
</td>
</tr>
<?php endwhile; ?>

</tbody>
</table>
</div>

<!-- ================= CONTACT QUERIES ================= -->
<div class="table-box">
<h3 style="color:#2a2a72">Contact Queries</h3>

<table>
<thead>
<tr>
  <th>ID</th>
  <th>Name</th>
  <th>Phone</th>
  <th>Email</th>
  <th>Message</th>
  <th>Date</th>
  <th>Status</th>
  <th>Action</th>
</tr>
</thead>
<tbody>

<?php if($qResult && $qResult->num_rows > 0): ?>
<?php while($q = $qResult->fetch_assoc()): ?>
<tr>
  <td><?= $q['id'] ?></td>
  <td><?= htmlspecialchars($q['name']) ?></td>
  <td><?= htmlspecialchars($q['phone']) ?></td>
  <td><?= htmlspecialchars($q['email']) ?></td>
  <td><?= nl2br(htmlspecialchars($q['message'])) ?></td>
  <td><?= date('d M Y h:i A', strtotime($q['created_at'])) ?></td>

  <td>
    <?php if($q['status']=='Resolved'): ?>
      <span class="badge Completed">Resolved</span>
    <?php else: ?>
      <span class="badge Pending">New</span>
    <?php endif; ?>
  </td>

  <td class="actions">
    <?php if($q['status']!='Resolved'): ?>
      <a class="btn-confirm" href="resolve_query.php?id=<?= $q['id'] ?>">Resolve</a>
    <?php endif; ?>
    <a class="btn-delete" href="delete_query.php?id=<?= $q['id'] ?>" onclick="return confirm('Delete this query?')">Delete</a>
  </td>
</tr>
<?php endwhile; ?>
<?php else: ?>
<tr>
  <td colspan="8" style="text-align:center">No contact queries found.</td>
</tr>
<?php endif; ?>

</tbody>
</table>
</div>

</body>
</html>
