<?php
session_start();
include '../includes/db.php';

if (isset($_SESSION['admin_logged_in'])) {
    header("Location: dashboard.php");
    exit;
}

$error = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $username = trim($_POST['username']);
    $password = trim($_POST['password']);

    $stmt = $conn->prepare(
        "SELECT id, username, password_hash FROM admins WHERE username=? LIMIT 1"
    );
    $stmt->bind_param("s", $username);
    $stmt->execute();
    $res = $stmt->get_result();

    if ($row = $res->fetch_assoc()) {
        if (password_verify($password, $row['password_hash'])) {
            $_SESSION['admin_logged_in'] = true;
            $_SESSION['admin_username'] = $row['username'];
            header("Location: dashboard.php");
            exit;
        } else {
            $error = "Invalid password";
        }
    } else {
        $error = "Invalid username";
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>Admin Login | Doctor Panel</title>
<meta name="viewport" content="width=device-width, initial-scale=1.0">

<style>
*{margin:0;padding:0;box-sizing:border-box;font-family:Poppins,Arial}
body{
  height:100vh;
  display:flex;
  justify-content:center;
  align-items:center;
  background:linear-gradient(135deg,#5563DE,#74ABE2)
}
.login-box{
  background:#fff;
  width:360px;
  padding:35px;
  border-radius:22px;
  box-shadow:0 20px 40px rgba(0,0,0,.25);
  text-align:center
}
.login-box h2{
  color:#2a2a72;
  margin-bottom:20px
}
input{
  width:100%;
  padding:12px;
  margin:10px 0;
  border-radius:10px;
  border:1px solid #ddd;
  font-size:15px
}
button{
  width:100%;
  padding:12px;
  background:linear-gradient(135deg,#5563DE,#74ABE2);
  color:#fff;
  border:none;
  border-radius:10px;
  font-weight:600;
  cursor:pointer;
  margin-top:10px
}
button:hover{opacity:.9}
.error{
  background:#fdecea;
  color:#c0392b;
  padding:8px;
  border-radius:8px;
  margin-bottom:10px
}
</style>
</head>

<body>

<div class="login-box">
  <h2>🔐 Admin Login</h2>
  <?php if($error): ?><div class="error"><?= htmlspecialchars($error) ?></div><?php endif; ?>
  <form method="POST">
    <input type="text" name="username" placeholder="Username" required>
    <input type="password" name="password" placeholder="Password" required>
    <button type="submit">Login</button>
  </form>
</div>

</body>
</html>
