<?php
session_start();
include '../includes/db.php';

if (!isset($_SESSION['admin_logged_in'])) {
    header("Location: index.php");
    exit;
}

$id     = intval($_GET['id'] ?? 0);
$status = $_GET['status'] ?? '';

$allowed = ['Pending','Confirmed','Completed','Cancelled'];

if ($id > 0 && in_array($status, $allowed)) {
    $stmt = $conn->prepare(
        "UPDATE appointments SET status=? WHERE id=?"
    );
    $stmt->bind_param("si", $status, $id);
    $stmt->execute();
}

header("Location: dashboard.php");
exit;
