<?php
include 'includes/db.php';

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    header("Location: index.php");
    exit;
}

/* ===== Collect & Sanitize ===== */
$name   = trim($_POST['name'] ?? '');
$phone  = trim($_POST['phone'] ?? '');
$email  = trim($_POST['email'] ?? '');
$type   = $_POST['appointment_type'] ?? '';
$date   = $_POST['appointment_date'] ?? '';
$time   = $_POST['appointment_time'] ?? '';
$desc   = trim($_POST['disease_description'] ?? '');

/* ===== Basic Validation ===== */
if ($name === '' || $phone === '' || $date === '' || $time === '' || $type === '') {
    echo "<script>
        alert('⚠️ Please fill all required fields.');
        history.back();
    </script>";
    exit;
}

/* ===== Check Slot Availability ===== */
$check = $conn->prepare(
    "SELECT id FROM appointments 
     WHERE appointment_date = ? AND appointment_time = ?"
);
$check->bind_param("ss", $date, $time);
$check->execute();
$check->store_result();

if ($check->num_rows > 0) {
    echo "<script>
        alert('❌ This time slot is already booked. Please choose another slot.');
        window.location.href='BookAppointmant.php?date=$date';
    </script>";
    exit;
}
$check->close();

/* ===== Insert Appointment (Payment Pending) ===== */
$stmt = $conn->prepare(
    "INSERT INTO appointments
     (name, phone, email, appointment_type,
      appointment_date, appointment_time, disease_description,
      payment_status, status)
     VALUES (?, ?, ?, ?, ?, ?, ?, 'Pending', 'Pending')"
);

$stmt->bind_param(
    "sssssss",
    $name,
    $phone,
    $email,
    $type,
    $date,
    $time,
    $desc
);

if ($stmt->execute()) {

    /* Get Appointment ID */
    $appointment_id = $conn->insert_id;

    /* Message + Redirect to payment.php */
    echo "<script>
        alert('✅ Appointment details saved!\\nPlease complete payment to confirm your appointment.');
        window.location.href='payment.php?id=$appointment_id';
    </script>";

} else {
    echo "<script>
        alert('❌ Something went wrong. Please try again.');
        history.back();
    </script>";
}

$stmt->close();
$conn->close();
