<?php
include 'includes/db.php';
$status_result = '';

if(isset($_POST['track_appointment'])){
    $phone = $_POST['track_phone'];
    $date  = $_POST['track_date'];

    $stmt = $conn->prepare(
      "SELECT status FROM appointments WHERE phone=? AND appointment_date=?"
    );
    $stmt->bind_param("ss",$phone,$date);
    $stmt->execute();
    $res = $stmt->get_result();

    if($res->num_rows){
        $row = $res->fetch_assoc();
        $status_result = "Your appointment status on <b>"
          .date('d M Y',strtotime($date)).
          "</b> is <b>".$row['status']."</b>";
    } else {
        $status_result = "No appointment found with given details.";
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>Track Appointment | Dr. Atul Kumar Soni</title>
<meta name="viewport" content="width=device-width, initial-scale=1.0">

<style>
*{margin:0;padding:0;box-sizing:border-box;font-family:Poppins,Arial,sans-serif}
body{background:#f4f7fb;color:#333}

/* ===== NAVBAR ===== */
nav{
  background:#fff;
  display:flex;
  justify-content:space-between;
  align-items:center;
  padding:15px 30px;
  box-shadow:0 5px 20px rgba(0,0,0,.08);
  position:sticky;
  top:0;
  z-index:1000;
}
.logo{
  font-size:22px;
  font-weight:700;
  color:#007bff;
}
.nav-links a{
  text-decoration:none;
  color:#333;
  margin:0 10px;
  font-weight:500;
  padding:8px 12px;
  border-radius:6px;
  transition:.3s;
}
.nav-links a:hover{background:#f1f1f1}
.nav-links a.active{
  background:#007bff;
  color:#fff;
}

/* ===== TRACK BOX ===== */
.track-page{
  max-width:450px;
  margin:100px auto;
  background:#fff;
  padding:35px;
  border-radius:25px;
  box-shadow:0 12px 30px rgba(0,0,0,.12);
  text-align:center;
}
.track-page h2{
  color:#2a2a72;
  margin-bottom:20px;
}
input,button{
  width:100%;
  padding:14px;
  margin:10px 0;
  border-radius:12px;
  border:none;
  font-size:15px;
}
button{
  background:#007bff;
  color:#fff;
  font-weight:600;
  cursor:pointer;
}
.status{
  margin-top:15px;
  font-weight:500;
}
</style>
</head>

<body>

<!-- ===== NAVBAR ===== -->
<nav>
  <div class="logo">Dr. Atul Soni</div>
  <div class="nav-links">
    <a href="index.php" class="<?= basename($_SERVER['PHP_SELF'])=='index.php'?'active':'' ?>">Home</a>
    <a href="About.php" class="<?= basename($_SERVER['PHP_SELF'])=='About.php'?'active':'' ?>">About Doctor</a>
    <a href="services.php" class="<?= basename($_SERVER['PHP_SELF'])=='services.php'?'active':'' ?>">Services</a>
    <a href="BookAppointmant.php" class="<?= basename($_SERVER['PHP_SELF'])=='BookAppointmant.php'?'active':'' ?>">Appointment</a>
    <a href="track.php" class="<?= basename($_SERVER['PHP_SELF'])=='track.php'?'active':'' ?>">Track</a>
    <a href="contact.php" class="<?= basename($_SERVER['PHP_SELF'])=='contact.php'?'active':'' ?>">Contact</a>
  </div>
</nav>

<!-- ===== TRACK CONTENT ===== -->
<div class="track-page">
  <h2>Track Appointment</h2>

  <form method="POST">
    <input type="text" name="track_phone" placeholder="Phone Number" required>
    <input type="date" name="track_date" required>
    <button name="track_appointment">Check Status</button>
  </form>

  <?php if($status_result): ?>
    <p class="status"><?= $status_result ?></p>
  <?php endif; ?>
</div>

</body>
</html>
